//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "GridForm.h"
#include "IWCompButton.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "MenuFrame"
#pragma link "IWBaseControl"
#pragma link "IWCompCheckbox"
#pragma link "IWControl"
#pragma link "IWGrids"
#pragma link "IWBaseHTMLControl"
#pragma link "IWVCLBaseControl"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
extern Currency FromCurrency(const AnsiString AText);
//---------------------------------------------------------------------------
__fastcall TformGrids::TformGrids(TComponent* Owner)
        : TIWAppForm(Owner)
{

}
//---------------------------------------------------------------------------

void __fastcall TformGrids::IWAppFormCreate(TObject *Sender)
{
int i;
Currency LAmount;
TStringList *LFirstNames, *LLastNames;

  try {
    LLastNames = new TStringList();
    LLastNames->Add("Smith");
    LLastNames->Add("Green");
    LLastNames->Add("Jones");
    LLastNames->Add("Wagner");
    LLastNames->Add("Black");
    LLastNames->Add("Donner");
    LLastNames->Add("Bush");

    try {
      LFirstNames = new TStringList();
      LFirstNames->Add("John");
      LFirstNames->Add("Mary");
      LFirstNames->Add("Elena");
      LFirstNames->Add("Nancy");
      LFirstNames->Add("James");
      LFirstNames->Add("George");
      LFirstNames->Add("Daryl");
      LFirstNames->Add("Deborah");
      LFirstNames->Add("Erik");
      LFirstNames->Add("Leon");
      LFirstNames->Add("Bill");
      LFirstNames->Add("Dan");

      tablGrid->Cell[0][1]->Text = "Name";
      tablGrid->Cell[0][2]->Text = "Date";
      tablGrid->Cell[0][3]->Text = "Amount";
      for (i = 1; i<=tablGrid->RowCount - 2; i++)
       {
       tablGrid->Cell[i][0]->Clickable = true;
       tablGrid->Cell[i][0]->Text = "Info";

       tablGrid->Cell[i][1]->Text = LFirstNames->Strings[random(LFirstNames->Count)] + " "
                       + LLastNames->Strings[random(LLastNames->Count)];
       tablGrid->Cell[i][2]->Text = IntToStr(random(12) + 1) + "/" + IntToStr(random(29) + 1) + "/"
             + IntToStr(random(3) + 1999);
       tablGrid->Cell[i][3]->Alignment = taRightJustify;
       LAmount = random(200);
       if (random(4) == 0)
         LAmount = -LAmount;
       tablGrid->Cell[i][3]->Text = CurrToStr(LAmount);

       tablGrid->Cell[i][4]->Control = new TIWButton(this);
       ((TIWButton*)tablGrid->Cell[i][4]->Control)->Caption = "Delete";
       ((TIWButton*)tablGrid->Cell[i][4]->Control)->Confirmation = "Delete this row?";
       ((TIWButton*)tablGrid->Cell[i][4]->Control)->OnClick = DeleteButtonClick;
       }
      tablGrid->Cell[tablGrid->RowCount - 1][3]->Alignment = taRightJustify;
      tablGrid->Cell[tablGrid->RowCount - 1][3]->Text = "0";
      tablGrid->Cell[tablGrid->RowCount - 1][3]->Font->Style = TFontStyles()<<fsBold;
      }
    __finally {
      //FreeAndNil(LFirstNames);
        delete LFirstNames;
        LFirstNames=NULL;
      }
    }
  __finally {
      //FreeAndNil(LLastNames);
      delete LLastNames;
      LLastNames=NULL;
    }
}
//---------------------------------------------------------------------------
void __fastcall TformGrids::tablGridCellClick(const int ARow,
      const int AColumn)
{
  WebApplication->ShowMessage(tablGrid->Cell[ARow][1]->Text + " has a balance of "
   + tablGrid->Cell[ARow][3]->Text);
}
//---------------------------------------------------------------------------
void __fastcall TformGrids::tablGridRenderCell(TIWGridCell *ACell,
      const int ARow, const int AColumn)
{
Currency LTotal;

  if (ARow == 0)
    {
    // Title Row
    ACell->Alignment = taCenter;
    ACell->BGColor = clBlue;
    ACell->Font->Style = TFontStyles()<<fsBold;
    }
  else if (ARow == tablGrid->RowCount - 1)
    {
    // Total Row
    LTotal = Total();
    if (LTotal < 0)
      ACell->Font->Color = clRed;
    else
      ACell->Font->Color = clBlue;
    ACell->Text = CurrToStr(LTotal);
    }
  else
    {
    // Alternate Row Colors
    if (ARow % 2 ==0)
      ACell->BGColor = clLtGray;
    else
      ACell->BGColor = clNone;
    // Mark negative values as red
    if (AColumn == 3)
      if (FromCurrency(ACell->Text) < 0)
        ACell->Font->Color = clRed;
    // We set the tags here, because when we delete we need to renumber them
    if (AColumn == 4)
      ((TIWButton*)ACell->Control)->Tag = ARow;
    }
}
//---------------------------------------------------------------------------
void __fastcall TformGrids::chckUseFrameClick(TObject *Sender)
{
  tablGrid->UseFrame = chckUseFrame->Checked;
}
//---------------------------------------------------------------------------

Currency __fastcall TformGrids::Total(void)
{
int i;
Currency result;

  result = 0;
  for (i=1; i<=tablGrid->RowCount - 2; i++)
    result += FromCurrency(tablGrid->Cell[i][3]->Text);
  return result;
}
//---------------------------------------------------------------------------
void __fastcall TformGrids::DeleteButtonClick(TObject *ASender)
{
  tablGrid->DeleteRow(((TComponent*)ASender)->Tag);
}
//---------------------------------------------------------------------------

Currency FromCurrency(const AnsiString AText)
{
int i;
AnsiString s, sAllowed;
Currency result;

  s = AText;
  sAllowed="0123456789.,";
  for (i = s.Length(); i>=1; i--)
    {
    if (sAllowed.Pos(s[i]) == 0)
      s.Delete(i, 1);
    }
  if (!TextToFloat(s.c_str(), &result, fvCurrency))
    result = 0;

  if ((AText.Pos("-") > 0) || (AText.Pos("(") > 0))
    result = -result;
  return result;
}
